% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildMixture.R
\name{buildMixtureDomains}
\alias{buildMixtureDomains}
\title{Create RHugin domains for computation.}
\usage{
buildMixtureDomains(
  n.unknown,
  data,
  domainnamelist,
  write,
  dir = NULL,
  ntraces = 1,
  triangulate = TRUE,
  compile = TRUE,
  compress = TRUE,
  use.order = TRUE
)
}
\arguments{
\item{n.unknown}{Number of unknown contributors}

\item{data}{A list of \code{data.frame}s on the form returned by
\code{\link{DNAmixtureData}}.}

\item{domainnamelist}{List of names for networkfiles.}

\item{write}{[not available in lite-version] Save networkfiles? Defaults to \code{FALSE}.}

\item{dir}{Path to the networkfiles.}

\item{ntraces}{Number of traces (EPG's)}

\item{triangulate}{Triangulate the networks? Default is to
triangulate the network using a good elimination order.}

\item{compile}{Compile the networks? Defaults to \code{TRUE}.}

\item{compress}{Compress the network? Defaults to \code{TRUE} and
is strongly recommended for models with a large number of
contributors.}

\item{use.order}{Should the default elimination order be used for
triangulation?  Otherwise the "total.weight" heuristic for
triangulation in HUGIN is used.}
}
\value{
A list containing a list of pointers for RHugin
domains. Additionally a list of the total size of the compressed
junction tree in percent of the uncompressed size.
}
\description{
The function is intended for internal use in
\code{\link{DNAmixture}}, and it creates one network per
marker.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\details{
For one marker, the network contains variables
\describe{
\item{\code{n_i_a}}{The number of alleles \eqn{a} that unknown contributor \code{Ui} possesses.}
\item{\code{S_i_a}}{Cumulative allele counts, summarising how many alleles amongst types 1, \ldots, \eqn{a} that contributor \eqn{i} possesses.}
\item{\code{O_r_a}}{Binary variable representing observed peak height for allele \eqn{a} in EPG \eqn{r}. See \code{\link{setCPT.O}} for details.}
\item{\code{D_r_a}}{Binary variable representing the event of a peak for allele \eqn{a} falling below threshold in EPG \eqn{r}.}
\item{\code{Q_r_a}}{Binary variable representing the event of a peak for allele \eqn{a} being smaller than the peak observed in EPG \eqn{r}.}
}

The network is by default triangulated, compiled,
compressed, and, optionally, saved as a hkb-file. If the networks
are large -- if there are many unknown contributors -- it is worth
considering saving the networks rather than re-building them every time
\code{DNAmixture} is called.
}
\note{
If amelogenin is included as a marker, use
integer codes for the alleles with X preceding Y, e.g. X=0, Y=1.
}
\author{
Therese Graversen
}
