% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prequentialScores.R
\name{prequential.score}
\alias{prequential.score}
\alias{plot.prequential.score}
\title{Calculate prequential scores}
\usage{
prequential.score(mixture, pars, markers = mixture$markers, by.allele = TRUE)

\method{plot}{prequential.score}(x, normalise = FALSE, ylab = NULL, ylim = NULL, ...)
}
\arguments{
\item{mixture}{A \code{DNAmixture} model object.}

\item{pars}{A \code{mixpar} model parameter.}

\item{markers}{An ordering of the markers, possibly a subset of the markers only.}

\item{by.allele}{Should conditioning be done allele-wise (\code{TRUE}) or EPG-wise (\code{FALSE}).
Defaults to \code{TRUE}. For details, see \code{\link{predict}}.}

\item{x}{A data.frame containing at least variables \code{marker} and \code{score}.}

\item{normalise}{Should the prequential score be normalised? Defaults to \code{FALSE}.}

\item{ylab}{Label for the y-axis.}

\item{ylim}{Range for the y-axis.}

\item{...}{Additional arguments to be passed on to \code{plot}.}
}
\value{
A data.frame, which contains the output from
\code{\link{predict}} as well as columns \code{Y}, \code{EY}, \code{VY}, corresponding
to the log-score and its mean and variance. Finally the variable
\code{score} is added, which is the normalised cumulative log-score.
}
\description{
\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\examples{
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K1", "K3"),
                  database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08,0.08),
            phi = list(c(U1 = 0.1, K3 = 0.2, K1 = 0.7), c(U1 = 0.1, K3 = 0.2, K1 = 0.7)))
preq <- prequential.score(mix, pars = p)
plot(preq, col = preq$trace)
## Annotate using repeat numbers
text(preq$score, labels = preq$allele, pos = c(1,3), col = preq$trace, cex = 0.6)
}
\author{
Therese Graversen
}
