% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPeakHeight.R
\name{rPeakHeight}
\alias{rPeakHeight}
\title{Simulate peak heights from a DNA mixture model.}
\usage{
rPeakHeight(
  mixture,
  pars,
  nsim = 1,
  markers = mixture$markers,
  dist = c("joint", "conditional"),
  use.threshold = TRUE,
  initialize = TRUE,
  ...
)
}
\arguments{
\item{mixture}{A \code{DNAmixture}.}

\item{pars}{A \code{mixpar} model parameter.}

\item{nsim}{Number of simulations for each allele.}

\item{markers}{Subset of markers to simulate}

\item{dist}{How should observed peak heights be taken into account?
Possible choices are
\describe{
\item{\code{"joint"}}{ which does not take peak heights into account.}
\item{\code{"conditional"}}{ which takes all peak heights into account, except that for the peak under consideration.}
}}

\item{use.threshold}{Should peak heights under the detection
threshold C be set to 0? Defaults to \code{TRUE}, corresponding to simulating under the model fitted.}

\item{initialize}{Should all propagated evidence be removed from
the network? Defaults to \code{TRUE}. If set to \code{FALSE}, the user should
make sure to check whether the networks represent the distribution
of interest.}

\item{...}{Not used.}
}
\value{
A list of one three-way array per marker; the three margins correspond to traces, alleles, and simulations.
}
\description{
A set of peak heights is sampled for each mixture in the
model. Note that if the mixtures cover different sets of markers,
so will the simulated peak heights. If there are unknown
contributors, their genotypes are sampled from the networks in
\command{mixture$domains}, but these genotypes are not stored.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\examples{
data(MC15, MC18, USCaucasian)

mixP <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = c("K1", "K3", "K2"),
                   database = USCaucasian)
pP <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08, 0.08),
             phi = list(c(K2 = 0.1, K3 = 0.2, K1 = 0.7), c(K2 = 0.1, K3 = 0.2, K1 = 0.7)))
rpk <- rPeakHeight(mixP, pP, nsim = 5)

\donttest{
mixD <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = c("K1", "K3"),
                   database = USCaucasian)
pD <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08, 0.08),
             phi = list(c(U1 = 0.1, K3 = 0.2, K1 = 0.7), c(U1 = 0.1, K3 = 0.2, K1 = 0.7)))
rpj <- rPeakHeight(mixD, pD, nsim = 5, dist = "joint")
rpc <- rPeakHeight(mixD, pD, nsim = 5, dist = "conditional")
}
}
\author{
Therese Graversen
}
