% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCPT.R
\name{setPeakInfo}
\alias{setPeakInfo}
\alias{removePeakInfo}
\title{Include or exclude peak information in the model}
\usage{
setPeakInfo(mixture, pars, presence.only = FALSE)

removePeakInfo(mixture)
}
\arguments{
\item{mixture}{A \code{\link{DNAmixture}}}

\item{pars}{A \code{\link{mixpar}} model parameter}

\item{presence.only}{Default is FALSE, which means that the full
peak height information is taken into consideration. Set to TRUE,
which will include only information on the presence and absence of peaks.}
}
\value{
invisibly \code{NULL}
}
\description{
The function \code{setPeakInfo} is used for including in the model
either the full peak height information or only information about
presence and absence of peaks. After a call to \code{setPeakInfo},
the Bayesian networks in \command{mixture$domains} will represent
the conditional distribution given the specified peak
information. For the reverse functionality, i.e. exclusion of any
such peak information, use \code{removePeakInfo}.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\details{
The function \code{setPeakInfo} sets conditional
probability tables using the specified model parameters, and
propagates suitable evidence using either observed peak heights or
the discrete presence/absence observations of peaks. Any
previously entered or propagated evidence on nodes \code{O} and
\code{D} will be retracted in this process.

The function \code{removePeakInfo} retracts all evidence on nodes
\code{O} and \code{D}; the conditional probability tables are left
unchanged.
}
\seealso{
\code{\link{setCPT}}. For use of the Bayesian networks, see \code{\link{map.genotypes}}.
}
