% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_M.R
\name{make.M}
\alias{make.M}
\title{Precision Matrix Function}
\usage{
make.M(X, covariates)
}
\arguments{
\item{X}{a matrix of spatial coordinates. It is recommended that the coordinates be scaled and centred.}

\item{covariates}{the observed values for the covariates (including intercept).}
}
\value{
A list containing the precision matrix M and the object M.eigen containing
eigenvalues and eigenvectors for the matrix M.
}
\description{
This function creates the precision matrix for the spatial prior based on thin-plate splines
and returns the matrix M, and its eigenvalues and eigenvectors
}
\details{
The M matrix is the precision matrix for the
 spatial effects from the direct sampling spatial prior (DSSP) model. M is based on
 thin plate splines basis functions, see White et. al. 2019 for more details on how the
 matrix M is constructed.
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y
X <- scale(coordinates(meuse.all))
make.M(X)
}
