% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesp.gen.mcnemar.R
\name{sesp.gen.mcnemar}
\alias{sesp.gen.mcnemar}
\title{Generalized McNemar's test}
\usage{
sesp.gen.mcnemar(tab)
}
\arguments{
\item{tab}{An object of class `tab.paired`.}
}
\value{
A vector containing the test statistic and the p-value.
}
\description{
Performs a generalized McNemar's test to jointly compare sensitivity and specificity.
}
\examples{
# Example 1:
data(Paired1) # Hypothetical study data
ftable(Paired1)
paired.layout1 <- tab.paired(d=d, y1=y1, y2=y2, data=Paired1)
print(paired.layout1)
sesp.gen.mcnemar(paired.layout1)

# Example 2 (from Lachenbruch and Lynch (1998)):
paired.layout2 <- read.tab.paired(
  d.a  = 850, d.b  = 40, d.c  = 60, d.d  =  50, 
  nd.a =  60, nd.b = 25, nd.c = 15, nd.d = 900, 
  testnames = c("T1", "T2")
)
print(paired.layout2)
sesp.gen.mcnemar(paired.layout2)

}
\references{
Lachenbruch P.A., Lynch C.J. (1998). Assessing screening tests: extensions of McNemar's test. \emph{Stat Med}, 17(19): 2207-17.
}
\seealso{
[tab.paired()], [read.tab.paired()] and [sesp.mcnemar()]
}
