% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_wls_error.R
\name{compute_wls_error}
\alias{compute_wls_error}
\title{Compute Weighted Least Squares Error (Internal)}
\usage{
compute_wls_error(sim_data, expert_values, weights)
}
\arguments{
\item{sim_data}{Numeric vector. A sample of simulated truncated Gamma values.}

\item{expert_values}{Named list. A list containing expert-provided statistics,
including \code{mean}, \code{median}, \code{sd}, \code{q25}, and \code{q975}. Some values may be NULL.}

\item{weights}{Numeric vector. A vector of weights for the WLS calculation,
corresponding to the importance of \code{c(mean, median, sd, q25, q975)}.}
}
\value{
Numeric. The weighted least squares error.
}
\description{
This function calculates the weighted least squares (WLS) error between
simulated truncated Gamma samples and expert-provided statistics.
It is used internally by \code{trunc_gamma_para()} and is not
intended for direct user access.
}
\keyword{internal}
