% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSUserDataObjectBase.R
\name{DSUserObjectGetAllResponse}
\alias{DSUserObjectGetAllResponse}
\title{DSUserObjectGetAllResponse}
\value{
DSUserObjectGetAllResponse object
}
\description{
This is the object returned for the client class' GetAllItems query only.\cr
\cr
For GetAllItems queries only, the returned objects will not have all their property fields set.\cr
Specifically for below:\cr
Expression: All property fields are fully populated.\cr
Index: The ConstituentsCount property will correctly specify the number of constituents but the
Constituents property will be NULL.\cr
List: The ConstituentsCount property will correctly specify the number of constituents but the
Constituents property will be NULL.\cr
Regression: All property fields are fully populated.\cr
Timeseries: The ValuesCount field of the DateRange property will specify the number of date value
pairs, but the Dates and Values fields will be NULL.\cr
You need to query for the individual object using the GetItem request to retrieve the full content
for the object.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{UserObjectType}}{specifies the returned object types. e.g. DSUserObjectTypes.List,
DSUserObjectTypes.TimeSeries, etc.}

\item{\code{UserObjects}}{An array of the specified object types such as DSListUserObject,
DSRegressionUserObject, etc.}

\item{\code{UserObjectsCount}}{The number of objects returned in the UserObjects property.}

\item{\code{ResponseStatus}}{This property will contain a DSUserObjectResponseStatus value.
DSUserObjectResponseStatus.UserObjectSuccess represents a successful response.}

\item{\code{ErrorMessage}}{If ResponseStatus is not DSUserObjectResponseStatus.UserObjectSuccess this status
string will provide a description of the error condition.}

\item{\code{Properties}}{Not currently used and will currently always return NULL.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSUserObjectGetAllResponse-new}{\code{DSUserObjectGetAllResponse$new()}}
\item \href{#method-DSUserObjectGetAllResponse-clone}{\code{DSUserObjectGetAllResponse$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectGetAllResponse-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectGetAllResponse-new}{}}}
\subsection{Method \code{new()}}{
Initialize
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectGetAllResponse$new(jsonResp = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonResp}}{JSON Response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectGetAllResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectGetAllResponse-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectGetAllResponse-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectGetAllResponse$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
