% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{Kappa}
\alias{Kappa}
\title{Compute the Cohen's kappa coefficient}
\usage{
Kappa(
  m,
  r = 0,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  partial = FALSE
)
}
\arguments{
\item{m}{a squared matrix of frequencies between two observers.}

\item{r}{an integer (0, 1, or 2) to create a matrix of weigths. See details.}

\item{alternative}{a string specifying the alternative hypothesis to construct the confidence interval:
either "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the interval.}

\item{partial}{a logical value indicating whether to evaluate the degree of agreement of each category by collapsing the contingency table.}
}
\value{
A list of 3 elements containing the kappa statistic, the standard error and the confidence interval.
If \code{"partial = TRUE"}, a data.frame containing 3 columns (the class, the unweighted partial kappa coefficient
for each class and the standards error of each estimate) is added to the list.
}
\description{
Kappa() computes de Cohen's kappa coefficient for nominal or ordinal data.
If data is ordinal, weigthed kappa can be applied to allow disagreements to be weighted differently.
}
\details{
The weighted kappa can be computed when data are ordinal and the argument \code{r} is eigher 1 or 2:
\itemize{
\item if r = 0, unweighted kappa is computed (used for nominal variables)
\item if r = 1, weighted kappa with linear formula is applied
\item if r = 2, weighted kappa with quadratic formula is applied
}
}
\examples{
# Create a 3x3 matrix
m = matrix(c(15, 5, 0, 4, 21, 1, 3, 4, 25), ncol = 3)
# Compute the Kapa coefficient for nominal data
Kappa(m, r = 0, partial = TRUE)
# Compute the Kapa coefficient for ordinal data, using linear formula
Kappa(m, r = 1)
}
