% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/am.R
\name{am}
\alias{am}
\title{Life Annuities for a group}
\usage{
am(
  x,
  h,
  n,
  k = 1,
  i = 0.04,
  data,
  prop = 1,
  type = "joint",
  quant = 1,
  assumption = "none",
  cap = 1
)
}
\arguments{
\item{x}{A vector of intergers representing the age of each individual of the group.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of payments per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age, and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{type}{A character string. Conditions to be met in order to access the benefit of the annuity ("joint", "exactly" or "atleast").}

\item{quant}{An integer. Required only if type is not "joint". If type is "exactly" it represents the exact amount of survivors required for the endowment to be payed. If type is "atleast", it represents the minimum number of survivors required.}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The annualized value of the payment.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a life annuity for a group.
}
\examples{
ages<-c(23,34,21)
ages<-c(23,34,21)
am(ages,5,10,2,0.05,CSO80MALB,1,"joint",assumption="UDD")
am(ages,0,20,1,0.06,CSO80FALBsmoker,1,"atleast",1)
am(ages,2,15,2,0.07,CSO80FANBsmoker,0.8,"exactly",2,"constant")

}
\keyword{Annuities}
\keyword{Group}
\keyword{Life}
