% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsdata.R
\docType{data}
\name{wren}
\alias{wren}
\alias{wren_5min}
\alias{wren_snapshot}
\alias{wren_cuecount}
\alias{wren_lt}
\alias{wren_5min_units}
\alias{wren_snapshot_units}
\alias{wren_cuecount_units}
\alias{wren_lt_units}
\title{Steve Buckland's winter wren surveys}
\source{
Steve Buckland
}
\description{
Observations of winter wren (\emph{Troglodytes troglodytes L.}) collected by Steve
Buckland in woodland/parkland at Montrave Estate near Leven, Fife, Scotland.
}
\details{
Four different surveys were carried out:
\itemize{
\item \code{wren_5min} 5-minute point count
\item \code{wren_snapshot} snapshot method
\item \code{wren_cuecount} cue count
\item \code{wren_lt} line transect survey
}
}
\note{
\code{wren_5min}: 134 observations of 8 variables
\itemize{
\item \code{Region.Label}  stratum name (single stratum)
\item \code{Area}  size (ha) of Montrave study area
\item \code{Sample.Label}  point label
\item \code{Effort}  Number of visits to point
\item \code{object}  Object ID
\item \code{distance}  radial distance (m)
\item \code{direction}  direction of detection from point
\item \code{Study.Area}  Montrave Estate
}

\code{wren_snapshot}: 119 observations of 7 variables
\itemize{
\item \code{Region.Label}  stratum name (single stratum)
\item \code{Area}  size (ha) of Montrave study area
\item \code{Sample.Label}  point label
\item \code{Effort}  Number of visits to point
\item \code{object}  Object ID
\item \code{distance}  radial distance (m)
\item \code{Study.Area}  Montrave Estate
}

\code{wren_cuecount}: 774 observations of 9 variables
\itemize{
\item \code{Region.Label}  stratum name (single stratum)
\item \code{Area}  size (ha) of Montrave study area
\item \code{Sample.Label}  point label
\item \code{Cue.rate}  Production rate (per min) of cues
\item \code{Cue.rate.SE}   SE of cue production rate
\item \code{object}  Object ID
\item \code{distance}  radial distance (m)
\item \code{Search.time}  Time (min) listening for cues
\item \code{Study.Area}  Montrave Estate
}

\code{wren_lt}: 156 observations of 8 variables
\itemize{
\item \code{Region.Label}  stratum name (single stratum)
\item \code{Area}  size (ha) of Montrave study area
\item \code{Sample.Label}  transect label
\item \code{Effort}   transect length (km)
\item \code{object}  Object ID
\item \code{distance}  perpendicular distance (m)
\item \code{Study.Area}  Montrave Estate
}
}
\references{
Buckland, S. T. (2006) Point-transect surveys for songbirds:
robust methodologies. The Auk 123 (2): 345–357.
}
\keyword{datasets}
