% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_control_chart.R
\name{plot_evaluation}
\alias{plot_evaluation}
\title{Evaluate and Visualize Control Charts by ROC curves}
\usage{
plot_evaluation(evaluate_control_chart)
}
\arguments{
\item{evaluate_control_chart}{an object of class evaluate_control_chart. \cr
\code{evaluate_control_chart} is an output from 
\code{evaluate_control_chart_one_group} or 
\code{evaluate_control_chart_two}.}
}
\value{
No return value, called for drawing two ROC plots.
}
\description{
Evaluate and Visualize Control Charts by ROC curves
}
\examples{
result_pattern<-estimate_pattern_long_surv(
  data_array=data_example_long_surv$data_array_IC,
  time_matrix=data_example_long_surv$time_matrix_IC,
  nobs=data_example_long_surv$nobs_IC,
  starttime=data_example_long_surv$starttime_IC,
  survtime=data_example_long_surv$survtime_IC,
  survevent=data_example_long_surv$survevent_IC,
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  estimation_method="risk",
  smoothing_method="local linear",
  bw_beta=0.05,
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_surv(
  data_array_new=data_example_long_surv$data_array_IC,
  time_matrix_new=data_example_long_surv$time_matrix_IC,
  nobs_new=data_example_long_surv$nobs_IC,
  pattern=result_pattern,
  method="risk",
  parameter=0.5)

output_evaluate<-evaluate_control_chart_one_group(
  chart_matrix=result_monitoring$chart,
  time_matrix=data_example_long_surv$time_matrix_IC,
  nobs=data_example_long_surv$nobs_IC,
  starttime=rep(0,nrow(data_example_long_surv$time_matrix_IC)),
  endtime=rep(1,nrow(data_example_long_surv$time_matrix_IC)),
  status=data_example_long_surv$survevent_IC,
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  no_signal_action="maxtime")

plot_evaluation(output_evaluate)
plot_PMROC(output_evaluate)

}
