% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcceptableMove.R
\name{AcceptableMove}
\alias{AcceptableMove}
\title{Check if move is acceptable.}
\usage{
AcceptableMove(proposal, qmax, self.loops, target, fixed.edges)
}
\arguments{
\item{proposal}{The proposed network (K-by-q matrix with K segments and q
parent sets).}

\item{qmax}{Maximum number of parents allowed.}

\item{self.loops}{Flag indicating whether self loops are allowed.}

\item{target}{The current target node (only needed to find out which parent
would be the self loop).}

\item{fixed.edges}{Which edges in the network should be fixed for all 
segments (q-by-q matrix with entries 0 for fixed non-edge, 1 for fixed edge,
-1 for non-fixed edge).}
}
\value{
Returns \code{TRUE} if the proposed move is acceptable, \code{FALSE}
otherwise.
}
\description{
This function takes as input a new network proposal and checks that the
proposal does not exceed the maximum number of parents for a node, and that
there are no self loops (if self loops have been disallowed).
}
\author{
Frank Dondelinger
}
\seealso{
\code{\link{make_structure_move}}
}

