% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateNetwork.R
\name{generateNetwork}
\alias{generateNetwork}
\title{Generate a random network.}
\usage{
generateNetwork(lambda_2 = 0.45, q = 10, min_phase_length = 1,
  k_bar = 5, l = 10, lambda_3 = 2, spacing = 1, gauss_weights = TRUE,
  same = FALSE, change_method = "sequential", fixed = FALSE, cps = NULL)
}
\arguments{
\item{lambda_2}{Average number of parents for each node in the network
(parameter for a Poisson distribution).}

\item{q}{Number of nodes.}

\item{min_phase_length}{Minimum segment length.}

\item{k_bar}{Maximum number of changepoints. If \code{fixed=TRUE}, this is
equal to the number of changepoints.}

\item{l}{Length of the time series.}

\item{lambda_3}{Average number of structure changes between two segments
(parameter for a Poisson distribution).}

\item{spacing}{\code{1} if segments are equally spaced, \code{0} if they are
spaced randomly (subject to the constraints of min_phase_length).}

\item{gauss_weights}{\code{1} if edge weights in the network are drawn from
N(0, 1), \code{0} if they are fixed to be 1.}

\item{same}{\code{1} if all segments have the same network structure (no
changes), \code{0} otherwise.}

\item{change_method}{\code{'sequential'} if the changes happen sequentially
(i.e. changes at segment i are applied to segment i-1),
\code{'hierarchical'} if the changes happen with respect to a hypernetwork
(i.e. changes at segment i are applied to segment 0).}

\item{fixed}{\code{T} if the changepoint locations are fixed, \code{F} if
they should be sampled.}

\item{cps}{Changepoint locations (if they are fixed).}
}
\value{
A list with the following elements: \item{network}{The network, a
list of length NumSegs, where each element is a NumNodes by NumNodes
matrix.} \item{epsilon}{The vector of changepoint locations.} \item{k}{The
number of changepoint.} \item{changes}{The number of changes among
segments.}
}
\description{
This function generates a random network with changepoints for structure
changes, for simulating synthetic data.
}
\examples{

# Generate random network with default parameters
network = generateNetwork()

# Simulate data using generated network
dataset = simulateNetwork(net=network)

# Generate random network with 4 changepoints and 15 nodes, 
# with changepoints distributed over a timeseries of length 50
network = generateNetwork(l=50, q=15, fixed=TRUE, k_bar=4)

# Simulate data of length 50 using generated network
dataset = simulateNetwork(net=network)

}
\author{
Frank Dondelinger
}
\seealso{
\code{\link{simulateNetwork}}
}

