% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geog.range.overlap.R
\name{geog.range.overlap}
\alias{geog.range.overlap}
\title{Takes two emtools.species objects with range rasters, calculates overlap between them as in Fitzpatrick and Turelli 2006.  This metric divides the area of overlap between two species ranges by the smaller of the two areas of the species' individual ranges.  It therefore ranges from 0 (no overlap) to 1 (ranges are the same or the smaller species' range is contained entirely within the larger).}
\usage{
geog.range.overlap(x, y)
}
\arguments{
\item{x}{An enmtools.species object containing a range raster}

\item{y}{An enmtools.species object containing a range raster}
}
\value{
A numeric value measuring range overlap.
}
\description{
Takes two emtools.species objects with range rasters, calculates overlap between them as in Fitzpatrick and Turelli 2006.  This metric divides the area of overlap between two species ranges by the smaller of the two areas of the species' individual ranges.  It therefore ranges from 0 (no overlap) to 1 (ranges are the same or the smaller species' range is contained entirely within the larger).
}
\examples{
cyreni <- iberolacerta.clade$species$cyreni
monticola <- iberolacerta.clade$species$monticola
cyreni$range <- background.raster.buffer(cyreni$presence.points, 100000, euro.worldclim)
monticola$range <- background.raster.buffer(monticola$presence.points, 100000, euro.worldclim)
geog.range.overlap(cyreni, monticola)
}
