% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_estimate.R
\name{estimate_multipleERPM}
\alias{estimate_multipleERPM}
\title{Estimate ERPM for multiple observations}
\usage{
estimate_multipleERPM(
  partitions,
  presence.tables,
  nodes,
  objects,
  effects,
  startingestimates,
  gainfactor = 0.1,
  a.scaling = 0.8,
  r.truncation.p1 = -1,
  r.truncation.p2 = -1,
  burnin = 30,
  thining = 10,
  length.p1 = 100,
  min.iter.p2 = NULL,
  max.iter.p2 = NULL,
  multiplication.iter.p2 = 200,
  num.steps.p2 = 6,
  length.p3 = 1000,
  neighborhood = c(0.7, 0.3, 0),
  fixed.estimates = NULL,
  numgroups.allowed = NULL,
  numgroups.simulated = NULL,
  sizes.allowed = NULL,
  sizes.simulated = NULL,
  double.averaging = FALSE,
  inv.zcov = NULL,
  inv.scaling = NULL,
  parallel = FALSE,
  parallel2 = FALSE,
  cpus = 1,
  verbose = FALSE
)
}
\arguments{
\item{partitions}{observed partitions}

\item{presence.tables}{XXX}

\item{nodes}{nodeset (data frame)}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{startingestimates}{first guess for the model parameters}

\item{gainfactor}{numeric used to decrease the size of steps made in the Newton optimization}

\item{a.scaling}{numeric used to reduce the influence of non-diagonal elements in the scaling matrix (for stability)}

\item{r.truncation.p1}{numeric used to limit extreme values in the covariance matrix (for stability)}

\item{r.truncation.p2}{numeric used to limit extreme values in the covariance matrix (for stability)}

\item{burnin}{integer for the number of burn-in steps before sampling}

\item{thining}{integer for the number of thining steps between sampling}

\item{length.p1}{number of samples in phase 1}

\item{min.iter.p2}{minimum number of sub-steps in phase 2}

\item{max.iter.p2}{maximum number of sub-steps in phase 2}

\item{multiplication.iter.p2}{value for the lengths of sub-steps in phase 2 (multiplied by  2.52^k)}

\item{num.steps.p2}{number of optimisation steps in phase 2}

\item{length.p3}{number of samples in phase 3}

\item{neighborhood}{way of choosing partitions: probability vector (actors swap, merge/division, single actor move)}

\item{fixed.estimates}{if some parameters are fixed, list with as many elements as effects, these elements equal a fixed value if needed, or NULL if they should be estimated}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{double.averaging}{option to average the statistics sampled in each sub-step of phase 2}

\item{inv.zcov}{initial value of the inverted covariance matrix (if a phase 3 was run before) to bypass the phase 1}

\item{inv.scaling}{initial value of the inverted scaling matrix (if a phase 3 was run before) to bypass the phase 1}

\item{parallel}{whether the phase 1 and 3 should be parallelized}

\item{parallel2}{whether there should be several phases 2 run in parallel}

\item{cpus}{how many cores can be used}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
A list with the outputs of the three different phases of the algorithm
}
\description{
Function to estimate a given model for given observed (multiple) partitions.
All options of the algorithm can be specified here.
}
\examples{
# define an arbitrary set of n = 6 nodes with attributes, and an arbitrary covariate matrix
n <- 6 
nodes <- data.frame(label = c("A","B","C","D","E","F"),
                    gender = c(1,1,2,1,2,2),
                    age = c(20,22,25,30,30,31)) 
friendship <- matrix(c(0, 1, 1, 1, 0, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 0, 0,
                       0, 1, 1, 0, 0, 1,
                       0, 0, 0, 0, 1, 0), 6, 6, TRUE) 

# specify whether nodes are present at different points of time
presence.tables <- matrix(c(1, 1, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1,
                            1, 0, 1, 1, 1, 1), 6, 3)

# choose effects to be included in the estimated model
effects_multiple <- list(names = c("num_groups","same","diff","tie","inertia_1"),
                objects = c("partitions","gender","age","friendship","partitions"),
                objects2 = c("","","","",""))
objects_multiple <- list()
objects_multiple[[1]] <- list(name = "friendship", object = friendship)

# define the observation
partitions <- matrix(c(1, 1, 2, 2, 2, 3,
                       NA, 1, 1, 2, 2, 2,
                       1, NA, 2, 3, 3, 1), 6, 3) 

\donttest{
# estimate
startingestimates <- c(-2,0,0,0,0)
estimation <- estimate_multipleERPM(partitions,
                                    presence.tables,          
                                    nodes, 
                                    objects_multiple, 
                                    effects_multiple, 
                                    startingestimates = startingestimates, 
                                    burnin = 100, 
                                    thining = 50,
                                    gainfactor = 0.6,
                                    length.p1 = 200, 
                                    multiplication.iter.p2 = 20, 
                                    num.steps.p2 = 4, 
                                    length.p3 = 1000) 

# get results table
estimation
}

}
