% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_burninthining.R
\name{gridsearch_burninthining_single}
\alias{gridsearch_burninthining_single}
\title{Grid - search burnin thining single}
\usage{
gridsearch_burninthining_single(
  partition,
  theta,
  nodes,
  effects,
  objects,
  num.steps,
  neighborhoods,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  max.thining,
  parallel = FALSE,
  cpus = 1
)
}
\arguments{
\item{partition}{A partition (vector)}

\item{theta}{Initial model parameters}

\item{nodes}{Node set (data frame)}

\item{effects}{Effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{Objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{num.steps}{Number of samples wanted}

\item{neighborhoods}{List of probability vectors (proba actors swap, proba merge/division, proba single actor move)}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{Vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{Vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{max.thining}{Where to stop adding thining}

\item{parallel}{False, to run different neighborhoods in parallel}

\item{cpus}{Equal to 1}
}
\value{
list
}
\description{
Function that simulates the Markov chain for a given model and several sets of transitions (the neighborhoods), for a single partition.
For each neighborhood, it calculates the autocorrelation of statistics for different thinings and the average statistics for different burn-ins.
Then the best neighborhood can be selected along with good values for burn-in and thining
}
