% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_burninthining.R
\name{simulate_burnin_single}
\alias{simulate_burnin_single}
\title{Simulate burn in single}
\usage{
simulate_burnin_single(
  partition,
  theta,
  nodes,
  effects,
  objects,
  num.steps,
  neighborhood,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated
)
}
\arguments{
\item{partition}{A partition (vector)}

\item{theta}{Initial model parameters}

\item{nodes}{Node set (data frame)}

\item{effects}{Effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{Objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{num.steps}{Number of samples wanted}

\item{neighborhood}{Way of choosing partitions: probability vector (proba actors swap, proba merge/division, proba single actor move)}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{Vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{Vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}
}
\value{
A list with list the draws, the moving.means and the moving means smoothed
}
\description{
Function that can be used to find a good length for the burn-in of the Markov chain for a given model and a given set of transitions in the chain (the neighborhood).
It draws a chain and calculates the mean statistics for different burn-ins.
}
