% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{A function that defines the true status based on the case definition}
\usage{
status(cases, r)
}
\arguments{
\item{cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{r}{Definition for the minimum difference in the mean number of cases, one week before and after each time point that, if present, should be detected. This is the case definition and the default is 0.2 (with 0 <= r <= 1). A value of r=0.2 means that we have a case when the mean number of the newly observed cases in the next 7 days is at least 20\% higher than the mean number of the newly observed cases in the past 7 days.}
}
\description{
Status = 1 when the expected rise in the number of cases occurs and Status = 0 when the expected rise in the number of cases does not occur
}
\examples{
data("Italy")
cases = mova(cases=Italy$Cases)
status = status(cases=cases, r=0.2)
}
