% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_rollEWS.R
\name{perm_rollEWS}
\alias{perm_rollEWS}
\title{Significance Testing of Rolling Window Early Warning Signals}
\usage{
perm_rollEWS(
  data,
  metrics,
  winsize = 50,
  variate = c("uni", "multi"),
  perm.meth = "arima",
  iter = 500
)
}
\arguments{
\item{data}{A dataframe where the first column is an equally spaced time vector and the remainder column are the time series to be assessed. If a two column dataframe is provided, and \code{variate = "uni"}, \code{uniEWS()} is called, whereas if number of columns exceeds two & \code{variate = "multi"}, then \code{multiEWS()} is called.}

\item{metrics}{String vector of early warning signal metrics to be assessed. For \code{variate = "uni"} these include: \code{"ar1"}, \code{"cv"}, \code{"SD"}, \code{"acf"}, \code{"rr"}, \code{"dr"}, \code{"skew"} and \code{"kurt"}. For \code{variate = "multi"}, pptions include: \code{"meanSD"}, \code{"maxSD"}, \code{"meanAR"}, \code{"maxAR"}, \code{"eigenMAF"}, \code{"mafAR"}, \code{"mafSD"}, \code{"pcaAR"}, \code{"pcaSD"}, \code{"eigenCOV"}, \code{"maxCOV"} and \code{"mutINFO"}.}

\item{winsize}{Numeric value. Defines the window size of the rolling window as a percentage of the time series length.}

\item{variate}{String. Is a \code{"uni"}variate or \code{"multi"}variate assessment to be made.}

\item{perm.meth}{String dictating the pseudo-randomisation technique to be used. Options include: "arima" (sampled from predictions of an ARIMA model), "red.noise" (red noise process using data mean, variance and autocorrelation coef) or "sample" (sampled from observed data without replacement).}

\item{iter}{Numeric value. The number of permutations.}
}
\value{
A list containing up to two objects: EWS outputs through time (\code{EWS}), and an identifier string (\code{method}).
\item{EWS$raw}{Dataframe of EWS measurements through time. Each metric's evolution over time is returned in individual columns.}
\item{EWS$cor}{Dataframe of Kendall Tau correlations and permuted p-values.}
\item{EWS$dimred.ts}{Dataframe containing the dimension reduction time series. Only returned if \code{variate = "multi"}.}
}
\description{
A function for identifying whether a warning has been generated from rolling early warning signal data using permutation tests. If a parallel connection is setup via \code{parallel} or \code{future} prior to usage of \code{perm_rollEWS()}, then the function is parallelised.
}
\examples{

data(simTransComms)

#Permute p value for a univariate
#time series using resampling

#(data trimmed for speed)
perm_uni <- perm_rollEWS(
data = simTransComms$community1[1:10,2:3],
 winsize = 75,
 variate = "uni",
 metrics = c("ar1", "SD", "skew"),
 perm.meth = "sample",
 iter = 25)

 #Permute p value for a multivariate
#community using a red.noise process

\donttest{
#if parallelisation desired,
#this can be achieved using the
#below code
cl <- parallel::makeCluster(2)
}

\donttest{
doParallel::registerDoParallel(cl)
}

perm_multi <- perm_rollEWS(
data = simTransComms$community1[1:10,2:7],
 winsize = 75,
 variate = "multi",
 metrics = c("meanAR", "maxAR", "meanSD"),
 perm.meth = "red.noise",
 iter = 25)

\donttest{
parallel::stopCluster(cl)
}

}
