% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilWaterBalance.R
\name{swb_f}
\alias{swb_f}
\title{Soil water balance}
\usage{
swb_f(R, Rstar, Emax, Ew, Ks, b, Zr, n, sh, sw, sstar, nsteps, s0, gr)
}
\arguments{
\item{R}{Daily rainfall, which should be a vector.}

\item{Rstar}{The maximum amount which the canopy intercepts}

\item{Emax}{Maximum evapotranspiration rate}

\item{Ew}{Minimum evapotranspiration rate}

\item{Ks}{Soil saturated hydraulic conductivity}

\item{b}{The exponent of the water retention curve}

\item{Zr}{Root depth}

\item{n}{The soil porosity}

\item{sh}{Soil moisture at hidroscopic point}

\item{sw}{Soil moisture at wilting point}

\item{sstar}{Soil moisture below field capacity point}

\item{nsteps}{Number of steps/division for the numerical solution}

\item{s0}{Initial soil moisture to start the simulation. If it is missing, s0 is signed equal to sh.}

\item{gr}{Logical argument to show graphics of results. Default is FALSE}
}
\value{
soil water balance components
}
\description{
This function calculates the daily soil water balance and its components based on the rainfall, soil properties and vegetation properties.
}
\details{
Soil water balance
}
\examples{
rain = 10 * RainPoisson(ndays = 365, lambda = 0.05, alpha = 0.60)
swb_f(R = rain, Rstar = 3, Emax = 5, Ew = 0.5, Ks = 2000, b = 4.38, Zr = 400,
n = 0.5, sh = 0.01, sw = 0.10, sstar = 0.25, s0 = 0.10, nsteps = 48)
}
