% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wassertsein_permut.R
\name{wasserstein_permut}
\alias{wasserstein_permut}
\title{Permutation test based on Wasserstein distance}
\usage{
wasserstein_permut(
  x,
  y,
  iterations = 10^4,
  fast = nrow(x) + nrow(y) > 10^3,
  S = NULL,
  ...
)
}
\arguments{
\item{x}{Samples from the first distribution}

\item{y}{Samples from the second distribution. Only used if x is a vector.}

\item{iterations}{How many iterations to do to simulate the null distribution.
Default to 10^4.}

\item{fast}{If true, uses the \link[transport]{subwasserstein}
approximate function. Default to true if there are more than 1,000 samples
total.}

\item{S}{Number of samples to use in approximate mode. Must be set if \code{fast=TRUE}.
See \link[transport]{subwasserstein}.}

\item{...}{Other parameters passed to \link[transport]{wasserstein} or
\link[transport]{wasserstein1d}}
}
\value{
A list containing the following components:
\itemize{
\item \emph{statistic} the Wasserstein distance between x and y.
\item \emph{p.value} the p-value of the permutation test.
}
}
\description{
Permutation test based on Wasserstein distance
}
\examples{
 x <- matrix(c(runif(100, 0, 1),
               runif(100, -1, 1)),
             ncol = 2)
 y <- matrix(c(runif(100, 0, 3),
               runif(100, -1, 1)),
             ncol = 2)
 # Set iterations to small number for runtime
 # Increase for more accurate results
 wasserstein_permut(x, y, iterations = 10^2)
}
