% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_interaction_probs.R
\name{generate_interaction_probs}
\alias{generate_interaction_probs}
\title{generate dyadic interaction probabilities for a group with fixed individual
and dyadic biases}
\usage{
generate_interaction_probs(n_ind, id_bias = 0, rank_bias = 0)
}
\arguments{
\item{n_ind}{numeric, number of individuals}

\item{id_bias}{numeric, between 0 and 1. If 0 all individual are equally
likely to interact. If 1, some individuals have higher propensities
to interact}

\item{rank_bias}{numeric, between 0 and 1. If 0 there is no relationship
between rank distance and interaction propensity. If 1 there is a
strong relationship: dyads closer in rank interact more often.}
}
\value{
a matrix
}
\description{
generate dyadic interaction probabilities for a group with fixed individual
and dyadic biases
}
\examples{


x <- generate_interaction_probs(n_ind = 10, id_bias = 0.2, rank_bias = 1)
rankdiff <- x[, 2] - x[, 1]
interactprob <- x[, "final"]
# closer in rank (smaller rank diff) = interaction more likely
plot(rankdiff, interactprob)

x <- generate_interaction_probs(n_ind = 10, id_bias = 0.2, rank_bias = 0)
rankdiff <- x[, 2] - x[, 1]
interactprob <- x[, "final"]
# approx. equal probs for all dyads regardless of rank diff
plot(rankdiff, interactprob)


x <- generate_interaction_probs(n_ind = 10, id_bias = 0, rank_bias = 0)
interactprob <- x[, "final"]
y <- sample(1:nrow(x), 1000, replace = TRUE, prob = interactprob)
y <- as.numeric(x[y, 1:2])
# approx. equal numbers of interactions per ID
sort(table(y))

# skewed interaction numbers
x <- generate_interaction_probs(n_ind = 10, id_bias = 1, rank_bias = 0)
interactprob <- x[, "final"]
y <- sample(1:nrow(x), 1000, replace = TRUE, prob = interactprob)
y <- as.numeric(x[y, 1:2])
sort(table(y))
}
