% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgelists.R
\name{get_discordant_edgelist}
\alias{get_discordant_edgelist}
\title{Get Discordant Edgelist Based on Specified Status Variable}
\usage{
get_discordant_edgelist(
  dat,
  status.attr,
  head.status,
  tail.status,
  networks = NULL
)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{status.attr}{The name of the status attribute of interest.}

\item{head.status}{The value(s) of \code{status.attr} for which to look for the head of the edge.
Can be a single value or a vector.}

\item{tail.status}{The value(s) of \code{status.attr} for which to look for the tail of the edge.
Can be a single value or a vector.}

\item{networks}{Numerical indexes of the networks to extract the partnerships
from. (May be > 1 for models with multiple overlapping
networks.) If \code{NULL}, extract from all networks.}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{head}: Positional ID of the head node.
\item \code{tail}: Positional ID of the tail node.
\item \code{head_status}: Status of the head node.
\item \code{tail_status}: Status of the tail node.
\item \code{network}: The numerical index of the network on which the partnership is located.
}
}
\description{
This function returns a \code{data.frame} with a discordant
edgelist, defined as the set of edges for which the status attribute
of interest is discordant between the two partners.
}
\details{
This is a generalized version of the \code{discord_edgelist} function.
It creates an edgelist of current partnerships in which the status attribute
of interest (as specified by the parameter \code{status.attr}) of one partner matches
the value (or one of the values) of the \code{head.status} parameter while the
corresponding status attribute of the other partner matches the value (or
one of the values) of the \code{tail.status} parameter.
}
\seealso{
\code{\link{discord_edgelist}}
}
\keyword{internal}
\keyword{netMod}
