% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{EpiTest.plot}
\alias{EpiTest.plot}
\title{Display variance component or directional epistasis graphs}
\usage{
EpiTest.plot(
  ETest,
  Title = NULL,
  Family_names = NULL,
  Colors = NULL,
  Type = "mean",
  Alpha = 5/100
)
}
\arguments{
\item{ETest}{a list as obtained from the EpiTest.fit function}

\item{Title}{(optional) a character string to be used as a title for the graph}

\item{Family_names}{(optional) a character vector with family names}

\item{Colors}{(optional) a character vector with three colors for the
graphical display (for variance graphs only)}

\item{Type}{a string with "mean" to display the directional epistasis plot or
"var" to display the variance component graph}

\item{Alpha}{type I error for the test, with 5\% default value
(for directional epistasis plot only)}
}
\value{
a ggplot graph
}
\description{
Display variance component or directional epistasis graphs
}
\examples{
data(Pheno.list)
data(Ancestry.list)

## Full NAM analysis
Parent.list <- Parents$Genotype[-1]
names(Parent.list) <- Parents$Family[-1]
ETest.nam <- purrr::imap(Parent.list, ~ EpiTest.fit(Ancestry = Ancestry.list[[.y]],
                                                    Pheno = Pheno.list[[.y]],
                                                    ParentName = c(P0 = 'B73',P1 = .x),
                                                    Parents = Parents,
                                                    Trait = 'GDD_DTA',
                                                    Weight = TRUE))
## Variance component plot
EpiTest.plot(ETest.nam,Title = 'Days to anthesis',Type = "var")

## Directional epistasis plot
EpiTest.plot(ETest.nam,Title = 'Days to anthesis',Type = "mean",Alpha = 5/100)
}
