% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-wrappers.r
\name{dim,Epoch-method}
\alias{dim,Epoch-method}
\alias{dimnames,Epoch-method}
\alias{[,Epoch-method}
\title{Wrapper functions for calling TableContainer methods}
\usage{
\S4method{dim}{Epoch}(x)

\S4method{dimnames}{Epoch}(x)

\S4method{[}{Epoch}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{An Epoch object}

\item{i}{Row indices for subsetting. If only \code{i} is provided, it will return the entire row(s).}

\item{j}{Column indices for subsetting.}

\item{...}{Additional arguments.}

\item{drop}{Not used.}
}
\value{
\code{[}: A new Epoch object with the selected data.
}
\description{
Wrapper functions for calling TableContainer methods
}
\examples{

# Create an Epoch object
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

# wrappers
dim(epoch)
dimnames(epoch)
epoch[1]

}
