% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNEwrapper.R
\name{tsneReductor}
\alias{tsneReductor}
\title{t-Distributed Stochastic Neighbor Embedding (t-SNE)}
\usage{
tsneReductor(data = NULL, dim = 2, perplexity = 30, max_iter = 500)
}
\arguments{
\item{data}{Data matrix (each row is an observation, each column is a variable)}

\item{dim}{Integer number; Output dimensional (default=2)}

\item{perplexity}{numeric; Perplexity parameter (should not be bigger than
3 * perplexity < nrow(X) - 1, default=30)}

\item{max_iter}{Integer; Number of iterations (default: 500)}
}
\value{
tsneY: A Matrix containing the new representations for the observation
         with selected dimensions by user
}
\description{
This method is an unsupervised, non-linear technique used for
data exploration and visualizing high-dimensional data.This function
constructs a low-dimensional embedding of high-dimensional
data, distances, or similarities.
}
\examples{
library("mlbench")
data(Sonar)

rndSamples <- sample(nrow(Sonar),150)
trainData <- Sonar[rndSamples,]
testData <- Sonar[-rndSamples,]

tsne_trainData <- tsneReductor(trainData[,1:60],dim = 3,perplexity = 10,max_iter = 1000)

}
