% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESS.R
\name{ESS}
\alias{ESS}
\title{ESS for two-player games with a maximum of three strategies}
\usage{
ESS(A, strategies = c(), floats = TRUE)
}
\arguments{
\item{A}{Numeric matrix of size 2x2 or 3x3 representing the number of
strategies of a symmetric matrix game.}

\item{strategies}{String vector of length n that names all strategies
whereas n represents the number of strategies.}

\item{floats}{Logical value that handles number representation. If set to
\code{TRUE}, floating-point arithmetic will be used, otherwise fractions.
Default is \code{TRUE}.}
}
\value{
Numeric matrix. Each row represents an ESS.
}
\description{
Computes Evolutionary Stable Strategies of a game with 
two players and a maximum of three strategies.
}
\examples{
ESS(matrix(c(-1, 4, 0, 2), 2, byrow=TRUE), c("Hawk", "Dove"), FALSE)
ESS(matrix(c(1, 2, 0, 0, 1, 2, 2, 0, 1), 3, byrow=TRUE))
}
\references{
Smith, J. M. and Price, G. R. (1973)
"The logic of animal conflict", 
Nature 246, pp. 15--18.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
