% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WbinoCI.R
\name{WbinoCI_upper}
\alias{WbinoCI_upper}
\title{An Admissible Exact Upper Interval for the Binomial Proportion}
\usage{
WbinoCI_upper(x, n, conf.level = 0.95, details = FALSE)
}
\arguments{
\item{x}{the number of success or the observed data.}

\item{n}{the sample size.}

\item{conf.level}{Confidence level. The default is 0.95.}

\item{details}{TRUE/FALSE, can be abbreviated. To choose whether to compute
the confidence interval for the whole sample points. The default is FALSE.}
}
\value{
A list which contains the confidence interval (CI) of the sample
point and the confidence intervals (CIM) for all the points.
}
\description{
The 1-alpha Clopper-Pearson upper interval for the binomial
proportion p.
}
\examples{
WbinoCI_upper(x=2,n=5,conf.level=0.95,details=TRUE)
WbinoCI_upper(x=2,n=5,conf.level=0.95)
}
\references{
Clopper, C. J. and Pearson, E. S. (1934). The use of confidence
or fiducial limits in the case of the binomial. "Biometrika" 26: 404-413.
}
