% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_m.R
\name{cov_m}
\alias{cov_m}
\title{The Function for Constructing the Covariance Matrix in \code{EzGP} Package}
\usage{
cov_m(X, p, q, m, n, parv, tau = 0, models = 0)
}
\arguments{
\item{X}{Matrix or data frame containing the inputs of training data. Each row represents the input setting of a data point and the columns are values of quantitative variables and qualitative variables.}

\item{p}{Number of quantitative factors in the given dataset \code{X}.}

\item{q}{Number of qualitative factors in the given dataset \code{X}.}

\item{m}{A vector containing numbers of levels in qualitative factors.}

\item{n}{Number of training data points}

\item{parv}{Parameters in the EzGP/EEzGP model}

\item{tau}{Nugget if needed. The default nugget is 0, otherwise it has to be a non-negative real value.}

\item{models}{Model indicator that indicates which model the covariance matrix is built for. 0 for EzGP model, 1 for EEzGP model. The default setting is 0.}
}
\value{
The covariance matrix for the given dataset.
}
\description{
Builds the covariance matrix for the given dataset according to different models.
}
\details{
\code{\link[EzGP]{EzGP_fit}}, \code{\link[EzGP]{EzGP_predict}}, \code{\link[EzGP]{EEzGP_fit}}, \code{\link[EzGP]{EEzGP_predict}}, \code{\link[EzGP]{LEzGP_fit}}, and \code{\link[EzGP]{LLF_gradients}} will call this function.
}
\note{
This function is used inside other functions in this package and is \strong{NOT} exported once the EzGP package is loaded.
}
\examples{
# see the examples in the documentation of the function EzGP_fit.
}
\references{
\enumerate{
\item "EzGP: Easy-to-Interpret Gaussian Process Models for Computer Experiments with Both Quantitative and Qualitative Factors", Qian Xiao, Abhyuday Mandal, C. Devon Lin, and Xinwei Deng (\doi{10.1137/19M1288462})
}
}
\seealso{
\code{\link[EzGP]{EzGP_fit}} to see how an EzGP model can be fitted to a training dataset.\cr
\code{\link[EzGP]{EzGP_predict}} to use the fitted EzGP model for prediction.\cr
\code{\link[EzGP]{EEzGP_fit}} to see how an EEzGP model can be fitted to a training dataset.\cr
\code{\link[EzGP]{EEzGP_predict}} to use the fitted EEzGP model for prediction.\cr
\code{\link[EzGP]{LEzGP_fit}} to see how a LEzGP model can be fitted to a training dataset.\cr
}
