% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{confint.femlm}
\alias{confint.femlm}
\title{Confidence interval for parameters estimated with femlm}
\usage{
\method{confint}{femlm}(object, parm, level = 0.95, se = c("standard",
  "white", "cluster", "twoway", "threeway", "fourway"), cluster,
  dof_correction = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{parm}{The parameters for which to compute the confidence interval (either an integer vector OR a character vector with the parameter name). If missing, all parameters are used.}

\item{level}{The confidence level. Default is 0.95.}

\item{se}{Character scalar. Which kind of standard error should be computed: \dQuote{standard} (default), \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}?}

\item{cluster}{A list of vectors. Used only if \code{se="cluster"}, \dQuote{se=twoway}, \dQuote{se=threeway} or \dQuote{se=fourway}. The vectors should give the cluster of each observation. Note that if the estimation was run using \code{cluster}, the standard error is automatically clustered along the cluster given in \code{\link[FENmlm]{femlm}}. For one-way clustering, this argument can directly be a vector (instead of a list). If the estimation has been done with cluster variables, you can give a character vector of the dimensions over which to cluster the SE.}

\item{dof_correction}{Logical, default is \code{FALSE}. Should there be a degree of freedom correction to the standard errors of the coefficients?}

\item{...}{Not currently used.}
}
\value{
Returns a data.frame with two columns giving respectively the lower and upper bound of the confidence interval. There is as many rows as parameters.
}
\description{
This function computes the confidence interval of parameter estimates obtained from a model estimated with \code{\link[FENmlm]{femlm}}.
}
\examples{

# Load trade data
data(trade)

# We estimate the effect of distance on trade (with 3 cluster effects)
est_pois = femlm(Euros ~ log(dist_km) + log(Year) | Origin + Destination +
                 Product, trade)

# confidence interval with "normal" VCOV
confint(est_pois)

# confidence interval with "clustered" VCOV (w.r.t. the Origin factor)
confint(est_pois, se = "cluster")


}
\author{
Laurent Berge
}
