% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIT.R
\name{predict}
\alias{predict}
\title{Predicts gene expressions using pretrained models.}
\usage{
predict(models, attribute, weather)
}
\arguments{
\item{models}{A list of trained models for the genes of interest.

    At the moment the collection of trained models returned
    by \code{FIT::train()} cannot be directly passed to \code{FIT::predict()}:
    the user has to explicitly convert it to an appropriate format by using
    \code{FIT::train.to.predict.adaptor()}.
    (This restriction might be removed in a future.)}

\item{attribute}{An object that represents the attributes of
microarray/RNA-seq data.
The object can be created from a dumped/saved dataframe
of size \code{nsamples * nattributes}
using \code{FIT::load.attribute()}.
(At the moment it is an instance of a hidden class IO$Attribute,
but this may be subject to change.)}

\item{weather}{An object that represents actual or hypothetical weather data
with which predictions of gene expressions are made.
The object can be created from a dumped/saved dataframe
of size \code{ntimepoints * nfactors}
using \code{FIT::load.weather()}.
(At the moment it is an instance of a hidden class IO$Weather,
but this may be subject to change.)}
}
\value{
A list of prediction results as returned by the models.
}
\description{
Predicts gene expressions using pretrained models.
}
\examples{
\dontrun{
# prepare models
# NOTE: FIT::train() returns a nested list of models
#   so we have to flatten it using FIT::train.to.predict.adaptor()
#   before passing it to FIT::predict().
models <- FIT::train(..)
models.flattened <- FIT::train.to.predict.adaptor(models)

# load data used for prediction
prediction.attribute  <- FIT::load.attribute('attribute.2009.txt')
prediction.weather    <- FIT::load.weather('weather.2009.dat', 'weather')
prediction.expression <- FIT::load.expression('expression.2009.dat', 'ex', genes)

prediction.results <- FIT::predict(models.flattened,
                                   prediction.attribute,
                                   prediction.weather)
}
}
