% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frcc.R
\name{rearrange.frcc}
\alias{rearrange.frcc}
\title{Rearranges the canonical structure according to the canonical correlations}
\usage{
rearrange.frcc(res.frcc)
}
\arguments{
\item{res.frcc}{List containing a canonical structure produced by the function frcc.}
}
\value{
A list containing the sorted canonical structure.
}
\description{
By using the minimum risk estimators of the correlation matrices instead of the
sample correlation matrices the FRCC algorithm might disrupt the order of the
canonical correlations and hence of the canonical structure. This is unacceptable
for the algorithm used  to calculate the p-values which requires the canonical
correlations to be ordered in a descending order. This function rearranges the
canonical structure according to the canonical correlations from largest to smallest.
}
\references{
Cruz-Cano, R.; Lee, M.L.T.; Fast Regularized Canonical Correlation Analysis,
Computational Statistics & Data Analysis, Volume 70, 2014, Pages 88-100,
ISSN 0167-9473, https://doi.org/10.1016/j.csda.2013.09.020.
}
\author{
Raul Cruz-Cano
}
\keyword{Internal}
