% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basisfns.R
\name{local_basis}
\alias{local_basis}
\alias{radial_basis}
\title{Construct a set of local basis functions}
\usage{
local_basis(
  manifold = sphere(),
  loc = matrix(c(1, 0), nrow = 1),
  scale = 1,
  type = c("bisquare", "Gaussian", "exp", "Matern32"),
  res = 1,
  regular = FALSE
)

radial_basis(
  manifold = sphere(),
  loc = matrix(c(1, 0), nrow = 1),
  scale = 1,
  type = c("bisquare", "Gaussian", "exp", "Matern32")
)
}
\arguments{
\item{manifold}{object of class \code{manifold}, for example, \code{sphere}}

\item{loc}{a matrix of size \code{n} by \code{dimensions(manifold)} indicating centres of basis functions}

\item{scale}{vector of length \code{n} containing the scale parameters of the basis functions; see details}

\item{type}{either \code{"bisquare"}, \code{"Gaussian"}, \code{"exp"}, or \code{"Matern32"}}

\item{res}{vector of length \code{n} containing the resolutions of the basis functions}

\item{regular}{logical indicating if the basis functions (of each resolution) are in a regular grid}
}
\description{
Construct a set of local basis functions based on pre-specified location and scale parameters.
}
\details{
This functions lays out local basis functions in a domain of interest based on pre-specified location and scale parameters. If \code{type} is ``bisquare'', then
\deqn{\phi(u) = \left(1- \left(\frac{\| u \|}{R}\right)^2\right)^2 I(\|u\| < R),}{\phi(u) = (1- (|u|/R)^2)^2 I(|u| < R),}
and \code{scale} is given by \eqn{R}, the range of support of the bisquare function. If \code{type} is ``Gaussian'', then
\deqn{\phi(u) = \exp\left(-\frac{\|u \|^2}{2\sigma^2}\right),}{\phi(u) = \exp(-|u|^2/2\sigma^2),}
and \code{scale} is given by \eqn{\sigma}, the standard deviation. If \code{type} is ``exp'', then
\deqn{\phi(u) = \exp\left(-\frac{\|u\|}{ \tau}\right),}{\phi(u) = \exp(-|u|/ \tau),}
and \code{scale} is given by \eqn{\tau}, the e-folding length. If \code{type} is ``Matern32'', then
\deqn{\phi(u) = \left(1 + \frac{\sqrt{3}\|u\|}{\kappa}\right)\exp\left(-\frac{\sqrt{3}\| u \|}{\kappa}\right),}{\phi(u) = (1 + \sqrt{3}|u|/\kappa)\exp(-\sqrt{3}|u|/\kappa),}
and \code{scale} is given by \eqn{\kappa}, the function's scale.
}
\examples{
library(ggplot2)
G <-  local_basis(manifold = real_line(),
                   loc=matrix(1:10,10,1),
                   scale=rep(2,10),
                   type="bisquare")
\dontrun{show_basis(G)}
}
\seealso{
\code{\link{auto_basis}} for constructing basis functions automatically, and \code{\link{show_basis}} for visualising basis functions.
}
