% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_general_info}
\alias{get_general_info}
\title{Returns the general info of an FSK object}
\usage{
get_general_info(fsk_obj)
}
\arguments{
\item{fsk_obj}{An object of class FSK2R}
}
\value{
A nested list with the following entries:
       \itemize{
         \item name
         \item source
         \item identifier
         \item creationDate
         \item rights
         \item language
         \item software
         \item creators
         \item reference
         }
}
\description{
Returns the general info of an FSK object
}
\examples{
\donttest{
 path_example <- system.file("extdata", "ToyModelv4.fskx", package = "FSK2R")
 my_fsk <- import_fsk(path_example)
 get_general_info(my_fsk)
}

}
