% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectSlope}
\alias{selectSlope}
\title{Select slope}
\usage{
selectSlope(s.threshold = 1.5)
}
\arguments{
\item{s.threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that selects features (in descending order from the best evaluation measure to the lowest) until the slope to the next feature is over a threshold (The features evaluation is individual). The slope is calculated as: (s.threshold) / (number of features). This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the direct search function with slope
ss_direct_search <- selectSlope()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
ss_direct_search(iris, 'Species', filter_evaluator)
}
}
\author{
Adan M. Rodriguez
}
