% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDgch.R
\name{IDgch}
\alias{IDgch}
\title{IDs of grandchildren of ego}
\usage{
IDgch(idego, d = NULL, keep_ego = FALSE)
}
\arguments{
\item{idego}{ID of ego(s)}

\item{d}{Name of database. If d is missing, the dataset dLH in the global environment (R workspace) is used. 
If no dLH in the global environment, the database dLH distributed with the Families package is used.}

\item{keep_ego}{If keep_ego=TRUE, parent-child-grandchild triads are shown.}
}
\value{
Two cases:
\itemize{
 \item keep_ego=FALSE: The function IDgch() returns the IDs of grandchildren. If ego has no grandchildren or IDs of grandchildren are not
included in database, the missing data symbol NA is returned. 
 \item keep_ego=TRUE: IDgch() returns a data frame of 
child-parent-grandparent triads. A triad consists of: 
\itemize{
   \item{idego}  ID of grandparent (ego)
   \item {idch}  ID of child
   \item {idgch} ID of grandchild
   \item{gp}     lineage: maternal grandfather, paternal grandmother, etc.
   \item{idMOM}  ID of mother of grandchild
   \item{idDAD}  ID of father of grandchild
   }
}
}
\description{
Retrieves ID of grandchildren of ego or vector of egos
}
\examples{

# Load data
data(dLH,package="Families")
IDch(IDch(dLH$ID[dLH$sex=="Female" & dLH$gen==1]))[1]

set.seed(51)
id <- sample (dLH$ID[dLH$gen==1],10)
id2 <- IDgch(idego=sort(id),keep_ego=TRUE)

}
