% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_file.R
\name{fedirt_file}
\alias{fedirt_file}
\title{Federated IRT model}
\usage{
fedirt_file(
  inputdata,
  model_name = "2PL",
  school_effect = FALSE,
  federated = "Avg",
  colname = "site"
)
}
\arguments{
\item{inputdata}{A dataframe.}

\item{model_name}{The name of the model you want to use. Can be "1PL" "2PL" or "graded". "1PL" refers to Rasch Model, "2PL" refers to two-parameter logistic model, "graded" refers to graded model.}

\item{school_effect}{A bool parameter, TRUE refers to considering the school effect as a fixed effect. Default is FALSE.}

\item{federated}{The federated learning method. Default is "Avg", meaning using Federated Average. Can also be "Med", meaning Federated Median.}

\item{colname}{Column name indicating the school.}
}
\value{
Corresponding model result as a list.
}
\description{
This function combines all types of algorithm of federated IRT models. It inputs a dataframe and return the estimated IRT parameters.
}
\details{
Input is a dataframe from each school with a column indicating the school name.
}
\examples{
\dontrun{
data <- read.csv("dataset.csv", header = TRUE)
fedresult <- fedirt_file(data, model_name = "2PL")
}
}
