% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_do_optim.R
\name{do_optim}
\alias{do_optim}
\title{Generate the sparse or p-rep allocation to multiple locations.}
\usage{
do_optim(
  design = "sparse",
  lines,
  l,
  copies_per_entry,
  add_checks = FALSE,
  checks = NULL,
  rep_checks = NULL,
  force_balance = TRUE,
  seed,
  data = NULL
)
}
\arguments{
\item{design}{Type of experimental design. It can be \code{prep} or \code{sparse}}

\item{lines}{Number of genotypes, experimental lines or treatments.}

\item{l}{Number of locations or sites. By default  \code{l = 1}.}

\item{copies_per_entry}{Number of copies per plant. 
When design is \code{sparse} then \code{copies_per_entry} should be less than \code{l}}

\item{add_checks}{Option to add checks. Optional if \code{design = "prep"}}

\item{checks}{Number of genotypes checks.}

\item{rep_checks}{Replication for each check.}

\item{force_balance}{Get balanced unbalanced locations. By default \code{force_balance = TRUE}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with 2 columns: \code{ENTRY | NAME }. ENTRY must be numeric.}
}
\value{
A list with three elements.
\itemize{
  \item \code{list_locs} is a list with each location list of entries.
  \item \code{allocation} is a matrix with the allocation of treatments.
  \item \code{size_locations} is a data frame with one column for each 
 location and one row with the size of the location.
}
}
\description{
Generate the sparse or p-rep allocation to multiple locations.
}
\examples{
sparse_example <- do_optim(
   design = "sparse",
   lines = 120, 
   l = 4, 
   copies_per_entry = 3, 
   add_checks = TRUE, 
   checks = 4,
   seed = 15
)
}
\references{
Edmondson, R.N. Multi-level Block Designs for Comparative Experiments. JABES 25, 
500–522 (2020). https://doi.org/10.1007/s13253-020-00416-0
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb]
}
