% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_correlation_matrix.R
\name{rand_cor_mat}
\alias{rand_cor_mat}
\title{Simulate a random correlation matrix}
\usage{
rand_cor_mat(
  n = 5,
  min.cor = -1,
  max.cor = 1,
  pos.def = FALSE,
  small.positive = NULL
)
}
\arguments{
\item{n}{A scalar defining the dimensions of the correlation matrix.}

\item{min.cor}{A scalar defining the minimum correlation.}

\item{max.cor}{A scalar defining the maximum correlation. \cr
\strong{Note:} \code{-1 < min.cor < max.cor < 1}.}

\item{pos.def}{When \code{TRUE} (default is \code{FALSE}), the function \code{bend} of the R package
\href{https://cran.r-project.org/package=mbend}{`mbend`} is used to
bend a non-positive (semi)-definite matrix to be positive (semi)-definite.}

\item{small.positive}{Argument passed to \code{bend} when \code{pos.def = TRUE} (default is 1e-8).
 Eigenvalues smaller than \code{small.positive} are replaced by this. \cr
\strong{Note:} \code{0 < small.positive < 0.1}.}
}
\value{
A symmetric \code{n x n} correlation matrix. When \code{pos.def = TRUE},
the correlation matrix is guaranteed to be positive (semi)-definite.
}
\description{
Creates a symmetric \code{n x n} correlation matrix with user-defined minimum and maximum
correlations based on a continuous uniform distribution.
}
\examples{
# Simulate and visualise a random correlation matrix with 10 columns and rows.
cor_mat <- rand_cor_mat(
  n = 10,
  min.cor = -0.2,
  max.cor = 0.8,
  pos.def = TRUE
)

plot_matrix(
  mat = cor_mat,
  order = TRUE
)

}
