% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_met.R
\name{sample_met}
\alias{sample_met}
\title{Sample environments from a target population}
\usage{
sample_met(
  ntraits = 1,
  nenvs = 1000,
  nsamples = 10,
  sample.size = 20,
  replace = TRUE,
  cov.mat = NULL
)
}
\arguments{
\item{ntraits}{A scalar defining the number of traits.}

\item{nenvs}{A scalar defining the number of environments in the target population.}

\item{nsamples}{A scalar defining the number of samples to be taken.}

\item{sample.size}{A vector defining the number of environments in each sample.
When only one value is specified, all samples will be assigned the same number.}

\item{replace}{When \code{TRUE} (default), samples are taken with replacement.
Ignored when \code{nsamples = 1}.}

\item{cov.mat}{An optional matrix of environmental covariates for one or more traits.
When supplied, the covariates are sampled and printed.}
}
\value{
A list with elements given by the sample of environments taken from the target population.
  When \code{cov.mat} is supplied, additional entries are given containing the sampled environmental
  covariates for each trait.
}
\description{
Creates a list of environments sampled from a population with user-defined sample size.
}
\examples{
# Sample environments from a target population of 1000, with each sample containing 20 environments.
cov_ls <- sample_met(
  nenvs = 1000,
  nsamples = 10,
  sample.size = 20,
  replace = TRUE
)

}
