% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMatrix.R
\name{model_frame}
\alias{model_frame}
\title{Construct Design Matrices for flexreg Objects}
\usage{
model_frame(object, ...)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of
\code{\link{flexreg}} or \code{\link{flexreg_binom}} functions.}

\item{...}{additional arguments. Currently not used.}
}
\description{
Method for extracting design matrix from fitted
regression model objects of class \code{`flexreg`}.
}
\details{
The method returns a list containing all the design matrices involved
in the regression models, namely \code{`X`} (regression on the mean), \code{`Z`}
(regression on the precision or overdispersion parameters), \code{`X0`} (regression
on the augmentation in zero probability), and/or \code{`X1`} (regression
on the augmentation in one probability).
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy.adj ~ iq, data = Reading, n.iter = 1000)
model.frame(FB)
}

}
