% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.frames.R
\name{screen.frames}
\alias{screen.frames}
\title{Plot one or more frames from the summary screening plot}
\usage{
screen.frames(
  metrics,
  type = "h",
  element = NULL,
  language = "English",
  mmar = c(3, 4, 0.5, 0.5),
  title = FALSE,
  multi = F,
  xaxis = T
)
}
\arguments{
\item{metrics}{output from \code{\link{metrics.all}}}

\item{type}{Character string indicating the set of metrics to plot.  Options
are "h" for high flow metrics, "l" for low flow metrics, or "b" for baseflow
metrics.}

\item{element}{Numeric index(es) (1-10) of the frame(s) to plot, see details of this function
for the list of metrics for each category (high, low, baseflow). Each category has
ten different metrics that can be plotted individually. Default is NULL, which creates
individual plots for all ten metrics. A list of elements c(1, 5, 10) can be specified
or a range c(1:5).}

\item{language}{Language for plot labels.  Choice of either "English" or
"French". Default is "English".}

\item{mmar}{Numeric vector specifying plot margins. Default is c(3,4,0.5,0.5)}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title. Set to FALSE to use this 
function in a multi-plot layout.}

\item{multi}{Boolean indicating whether the function is being used to create one plot
in a multi-plot layout. Default is F. If T, suppresses the reset of plot parameter settings.
This plot function will only work for a multi-plot layout if text=F}

\item{xaxis}{Boolean indicating whether to plot an x-axis. Default = T.}
}
\description{
This function plots one or more frames (i.e. time series plot) from any of the three 
plot.screening summary plots at a time. It can be used to create custom
summary plots - see the example code.
}
\details{
High flow metrics include:
  \enumerate{
    \item Annual Maximum Series
    \item Annual Maximum Day of Year
    \item Peaks Over Threshold (Qmax)
    \item Inter-Event Duration
    \item Q80
    \item Q90
    \item Day of Year 25 percent Annual Flow
    \item Center of Volume
    \item Day of Year 75 percent Annual Flow
    \item Duration between 25 percent and 75 percent Annual Flow
  }
  
  Low flow metrics include:
  \enumerate{
    \item Q10
    \item Q25
    \item Drought Start
    \item Drought Center
    \item Drought End
    \item Drought Duration
    \item Drought Severity
    \item Annual Minimum Flow
    \item Mean Annual Minimum 7-day Flow
    \item Mean Annual Minimum 10-day Flow
  }
  
  Baseflow metrics include:
  \enumerate{
    \item Mean Daily Discharge
    \item Annual Baseflow Volume
    \item Annual Mean Baseflow
    \item Annual Maximum Baseflow
    \item Annual Minimum Baseflow
    \item Mean Annual Baseflow Index
    \item Day of Year 25 percent Baseflow Volume
    \item Center of Volume Baseflow
    \item Day of Year 75 percent Baseflow Volume
    \item Duration between 25 percent and 75 percent Baseflow Volume
  }
}
\examples{
# load results from metrics.all function for the Caniapiscau River
data(caniapiscau.res)
caniapiscau.ts <- caniapiscau.res$indata

# plot one frame from the baseflow screening plot
screen.frames(caniapiscau.res, type="b", element=1)

# plot three frames from the low flow screening plot
screen.frames(caniapiscau.res, type="l", element=c(1:3))

# create a custom summary plot
opar <- par(no.readonly = TRUE)
layout(matrix(c(1,2,3,4), 2, 2, byrow=TRUE))
par(oma=c(0,0,3,0))
stninfo <- station.info(caniapiscau.ts$Agency[1], caniapiscau.ts$ID[1], Plot=TRUE)
screen.frames(caniapiscau.res, type="h", element=1, multi=TRUE)
screen.frames(caniapiscau.res, type="l", element=1, multi=TRUE)
screen.frames(caniapiscau.res, type="b", element=1, multi=TRUE)

par <- opar
layout(1,1,1)

# or plot everything!
opar <- par(no.readonly = TRUE)
layout(matrix(c(1:30), 5, 6, byrow=TRUE))
screen.frames(caniapiscau.res, type="h", multi=TRUE)
screen.frames(caniapiscau.res, type="l", multi=TRUE)
screen.frames(caniapiscau.res, type="b", multi=TRUE)
par <- opar
layout(1,1,1)
}
\author{
Jennifer Dierauer and Paul Whitfield
}
