\name{fitbayesJSB}
\alias{fitbayesJSB}
\title{Estimating parameters of the Johnson's SB (JSB) distribution using the Bayesian approach}
\description{Suppose \eqn{x=(x_1,\dots,x_n)^T} denotes a vector of \eqn{n} independent observations coming from a four-parameter JSB distribution with probability density function given given by
\deqn{
f\bigl(x\big|\Theta\bigr) = \frac {\delta \lambda}{\sqrt{2\pi}(x-\xi)(\lambda+\xi-x)}\exp\Biggl\{-\frac{1}{2}\Bigg[\gamma+\delta\log \biggl(\frac{x-\xi}{\lambda+\xi-x}\biggr) \Bigg]^2\Biggr\},
}
where \eqn{\xi<x<\lambda+\xi}, \eqn{\Theta=(\delta,\gamma,\lambda,\xi)^T} with \eqn{\delta, \lambda> 0}, \eqn{-\infty<\gamma<\infty}, and \eqn{-\infty<\xi<\infty}. Using the Bayesian approach, we compute the Bayes' estimators of the JSB distribution parameters.}
\usage{fitbayesJSB(data, n.burn=8000, n.simul=10000)}
\arguments{
  \item{data}{Vector of observations.}
  \item{n.burn}{Length of the burn-in period, i.e., the point after which Gibbs sampler is supposed to attain convergence. By default \code{n.burn} is 8000.}
  \item{n.simul}{Total numbers of Gibbs sampler iterations. By default \code{n.simul} is 10,000.}
}
\details{The Bayes' estimators are obtained by averaging on the all iterations between \code{n.burn} and \code{n.simul}.}
\value{A list of objects in two parts as
\enumerate{
\item Bayes' estimators of the parameters.
\item A sequence of four goodness-of-fit measures consist of Anderson-Darling (\code{AD}), Cramer-von Mises (\code{CVM}), Kolmogorov-Smirnov (\code{KS}), and  log-likelihood (\code{log-likelihood}) statistics.
}
}
\references{
N. L. Johnson, 1949. Systems of frequency curves generated by methods of translation, \emph{Biometrika}, 36, 149–176.

L. J. Norman, S. Kotz, and N. Balakrishnan, 1994. \emph{Continuous Univariate Distributions}, volume I, John Wiley & Sons.
}
\author{Mahdi Teimouri}
\examples{
\donttest{
# Here we use the SW dataset provided by FIA that represents a typical loblolly pine plantation.
# As the variable of interest, we fit the JSB distribution to the diameter at breast height (SW$DIA)
# in inches.
data(SW)
data<-SW$DIA
fitbayesJSB(data, n.burn=4000, n.simul=5000)
}
}

