% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vwf.R
\name{vwf}
\alias{vwf}
\title{Variable Window Filter}
\usage{
vwf(
  CHM,
  winFun,
  minHeight = NULL,
  warnings = TRUE,
  minWinNeib = "queen",
  IDfield = "treeID",
  resolution_round = 5
)
}
\arguments{
\item{CHM}{SpatRaster. Canopy height model in SpatRaster format.}

\item{winFun}{function. The function that determines the size of the window at any given location on the
canopy. It should take the value of a given \code{CHM} pixel as its only argument, and return the desired *radius* of
the circular search window when centered on that pixel. Size of the window is in map units.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as a potential treetop. All \code{CHM} pixels beneath
this value will be masked out.}

\item{warnings}{logical. If set to FALSE, this function will not emit warnings related to inputs.}

\item{minWinNeib}{character. Define whether the smallest possible search window (3x3) should use a \code{queen} or
a \code{rook} neighborhood.}

\item{IDfield}{character. Name of field for unique tree identifier}

\item{resolution_round}{integer. The raster resolution is used to compute the dimensions of the search windows. By default, this resolution is rounded
to 5 decimal places. The number of decimal places can be changed using this parameter. Increasing this value is also a work-around for errors
relating to non-square cell sizes.}
}
\value{
Simple feature collection of POINT type. The point locations of detected treetops. The object contains two fields in its
data table: \emph{height} is the height of the tree, as extracted from the \code{CHM}, and \emph{winRadius} is the radius
of the search window when the treetop was detected. Note that \emph{winRadius} does not necessarily correspond to the radius
of the tree's crown.
}
\description{
Implements the variable window filter algorithm (Popescu & Wynne, 2004) for detecting treetops from a canopy height model.
}
\details{
This function uses the resolution of the raster to figure out how many cells the window needs to cover.
This means that the raster value (representing height above ground) and the map unit (represented by the raster's resolution),
need to be in the _same unit_. This can cause issues if the raster is in lat/lon, whereby its resolution is in decimal degrees.
}
\examples{
\dontrun{
library(terra)
library(ForestTools)

chm <- rast(kootenayCHM)

# Set function for determining variable window radius
winFunction <- function(x){x * 0.06 + 0.5}

# Set minimum tree height (treetops below this height will not be detected)
minHgt <- 2

# Detect treetops in demo canopy height model
ttops <- vwf(chm, winFunction, minHgt)
}

}
\references{
Popescu, S. C., & Wynne, R. H. (2004). Seeing the trees in the forest. \emph{Photogrammetric Engineering & Remote Sensing, 70}(5), 589-604.
}
\seealso{
\code{\link{mcws}}
}
