% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMM_init.R
\name{HMM.init}
\alias{HMM.init}
\title{Initialization for the ECM algorithm}
\usage{
HMM.init(X, k = 1:3, nstartR = 100, ncores = 1, verbose = FALSE)
}
\arguments{
\item{X}{An array of dimension \code{p} x \code{r} x \code{n} x \code{t}, where \code{p} is the number of
variables in the rows of each data matrix, \code{r} is the number of variables in the columns of each
data matrix, \code{n} is the number of data observations and \code{t} is the number of times.}

\item{k}{An integer or a vector indicating the number of states of the models.}

\item{nstartR}{An integer specifying the number of random starts to be considered.}

\item{ncores}{A positive integer indicating the number of cores used for running in parallel.}

\item{verbose}{A logical indicating whether the running output should be displayed.}
}
\value{
\item{init}{A list of objects to be used by the \code{HMM.fit()} function.}
}
\description{
Runs the initialization of the ECM algorithm used for fitting the parsimonious hidden Markov models.
Parallel computing is implemented and highly recommended for a faster calculation.
}
\examples{
data(simX)

init <- HMM.init(X = simX, k = 2, nstartR = 1)
}
