% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxtix_tranz.R
\name{maxtix_tranz}
\alias{maxtix_tranz}
\alias{eigen_module}
\alias{positive_matrix_calc}
\alias{transitive_closure}
\alias{matrix_transitive_join}
\alias{consonanse_dissonanse}
\alias{cross_consonanse}
\alias{cross_dissonanse}
\alias{cross_positive_influence}
\alias{cross_negative_influence}
\alias{impuls_vector}
\alias{multiply_vector}
\alias{multiply_matrix}
\alias{maximum_matrix}
\alias{ik_pos_maximum}
\alias{ik_neg_maximum}
\alias{reverse_task}
\alias{direct_task}
\title{matrix_tranz}
\usage{
tnorm_functions

snorm_functions

snorm_functions_reverse

tnorm_functions_reverse

positive_matrix_calc(initmatrix)

transitive_closure(
  positivematrix,
  tnorm,
  snorm,
  snormMatrix,
  gammaTnormMean,
  algaTnorm,
  gammaTnorm,
  piTnorm,
  gammaSnorm,
  piSnorm
)

matrix_transitive_join(matrix, snorm, gammaSnorm, piSnorm)

consonanse_dissonanse(finalmatrix)

cross_consonanse(finalmatrix)

cross_dissonanse(finalmatrix)

cross_positive_influence(finalmatrix)

cross_negative_influence(finalmatrix)

impuls_vector(vector, matrix)

multiply_vector(matrix, vector)

multiply_matrix(
  matrix_1,
  matrix_2,
  tnorm,
  snorm,
  gammaTnormMean,
  algaTnorm,
  gammaTnorm,
  piTnorm,
  gammaSnorm,
  piSnorm
)

maximum_matrix(matrix_1, matrix_2)

ik_pos_maximum(matrix, initMatrix, ipath, jpath)

ik_neg_maximum(matrix, initMatrix, ipath, jpath)

reverse_task(
  df_matrix,
  vectorY,
  tnorm,
  tnorm_reverse,
  snorm,
  snormMatrix,
  snorm_reverse
)

direct_task(df_matrix, vectorX, tnorm, snorm, snormMatrix)
}
\arguments{
\item{initmatrix}{matrix}

\item{positivematrix}{matrix}

\item{tnorm}{function}

\item{snorm}{function}

\item{snormMatrix}{function}

\item{gammaTnormMean}{function}

\item{algaTnorm}{function}

\item{gammaTnorm}{function}

\item{piTnorm}{function}

\item{gammaSnorm}{function}

\item{piSnorm}{function}

\item{matrix}{matrix}

\item{finalmatrix}{matrix}

\item{vector}{matrix}

\item{matrix_1}{matrix}

\item{matrix_2}{matrix}

\item{initMatrix}{matrix}

\item{ipath}{vector}

\item{jpath}{vector}

\item{df_matrix}{matrix}

\item{vectorY}{vector}

\item{tnorm_reverse}{function}

\item{snorm_reverse}{function}

\item{vectorX}{vector}
}
\value{
eigen values of \code{initmatrix}

positive matrix of \code{initmatrix}

transitive closure of \code{positivematrix}

aggregation function for transitive closure of \code{matrix}

system indicators of \code{finalmatrix}

cross consonanse of \code{finalmatrix}

cross dissonanse of \code{finalmatrix}

cross positive influence of \code{finalmatrix}

cross negative influence of \code{finalmatrix}

impulse of \code{matrix} based on \code{vector}

multiplication of \code{matrix} and \code{vector}

multiplication of \code{matrix_1} and \code{matrix_2}

maximum of \code{matrix_1} and \code{matrix_2}

ik walk for \code{matrix} based on \code{initMatrix} with \code{ipath} and \code{jpath}

ik negative walk for \code{matrix} based on \code{initMatrix} with \code{ipath} and \code{jpath}

reverse task solution for \code{df_matrix} with \code{vectorY} using \code{tnorm}, \code{tnorm_reverse}, \code{snorm}, \code{snormMatrix}, \code{snorm_reverse}

direct task solution for \code{df_matrix} with \code{vectorX} using \code{tnorm}, \code{snorm}, \code{snormMatrix}
}
\description{
The maxtix_tranz set of functions is aimed to calculate dissonance, consonance and influence
}
