% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Extract.R
\docType{methods}
\name{Extract}
\alias{Extract}
\alias{[,FuzzyNumber,character-method}
\alias{[,PiecewiseLinearFuzzyNumber,character-method}
\alias{[,PowerFuzzyNumber,character-method}
\alias{[,DiscontinuousFuzzyNumber,character-method}
\title{FuzzyNumber Slot Accessors}
\usage{
\S4method{[}{FuzzyNumber,character}(x, i)

\S4method{[}{PiecewiseLinearFuzzyNumber,character}(x, i)

\S4method{[}{PowerFuzzyNumber,character}(x, i)

\S4method{[}{DiscontinuousFuzzyNumber,character}(x, i)
}
\arguments{
\item{x}{a fuzzy number}

\item{i}{character; slot name}
}
\value{
Returns the slot value.
}
\description{
For possible slot names see man pages for the \linkS4class{FuzzyNumber} class and its derivatives
}
\details{
All slot accessors are read-only.
}
\examples{
A <- FuzzyNumber(1,2,3,4)
A["a1"]
A["right"]
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{distance}()},
\code{\link{evaluate}()},
\code{\link{expectedInterval}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}

Other PowerFuzzyNumber-method: 
\code{\link{PowerFuzzyNumber-class}},
\code{\link{PowerFuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()}

Other DiscontinuousFuzzyNumber-method: 
\code{\link{DiscontinuousFuzzyNumber-class}},
\code{\link{DiscontinuousFuzzyNumber}},
\code{\link{distance}()},
\code{\link{integrateAlpha}()},
\code{\link{plot}()}
}
\concept{DiscontinuousFuzzyNumber-method}
\concept{FuzzyNumber-method}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{PowerFuzzyNumber-method}
