% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyq.R
\name{fuzzyq}
\alias{fuzzyq}
\title{Fuzzy Quantification of Common and Rare Species in Ecological Communities}
\usage{
fuzzyq(
  M,
  diss = "gower",
  rm.absent = FALSE,
  sorting = TRUE,
  keep.Diss = FALSE,
  std = FALSE,
  wgts = c(1, 1),
  ...
)
}
\arguments{
\item{M}{A matrix or data frame of species abundances (columns). Each row
represents a site.}

\item{diss}{String. Specify the dissimilarity coefficient to be used. Default
is "gower". See \code{\link[cluster]{daisy}} in package \code{cluster} for
other choices.}

\item{rm.absent}{Logical. Whether or not absent species are to be removed
from the calculations.}

\item{sorting}{Logical. If \code{TRUE} (the default) species are sorted in
the output by ascending silhouette widths within each cluster, else species
are arranged in the same order as in the input matrix or data frame.}

\item{keep.Diss}{Logical. Whether or not the species dissimilarity matrix
shoudl be returned. The default is \code{FALSE}.}

\item{std}{Logical. Whether or not the measurements of occupancy and
abundance are to be standardized before calculating the dissimilarities.
Measurements are standardized for each variable (column), by subtracting
the variable's mean value and dividing by the variable's mean absolute
deviation. It only takes effect if \code{diss} is different from "gower".}

\item{wgts}{an optional numeric vector of length 2. To be used if diss =
"gower", specifying weights for occupancy and abundance, respectively.
Default is 1 each as in Gower's original formula.}

\item{...}{Arguments to be passed to function \code{fanny} in package
\code{cluster}.}
}
\value{
A list of class \code{fuzzyq} containing the following: \describe{
  \item{\code{A_O}}{Abundance-occupancy information for each species.}
  \item{\code{Diss}}{Object of class dist with pairwise dissimilarities among
  species based on A_O. (only if \code{keep.Diss = TRUE)}.}
  \item{\code{spp}}{Clustering metrics per species: Cluster membership (where
  0 and 1 denote allocation to the rare and common category, respectively),
  Silhouette Widths and Commonness Indices).} \item{\code{global}}{Community
  level clustering metrics: Average silhouette widths per cluster and
  globally, Mean commonness indices per cluster and Normalized Dunn's
  coefficient.} }
}
\description{
Perform fuzzy clustering of each species based on their abundance and
occupancy.
}
\examples{
data(antsA)
FQAnts <- fuzzyq(antsA, sorting = TRUE)
}
\seealso{
\code{\link[cluster]{fanny}} and \code{\link[cluster]{daisy}} in
package \code{cluster}
}
