% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nmarkers_SimpleM.R
\name{Nmarkers_SimpleM}
\alias{Nmarkers_SimpleM}
\title{Estimate the number of effective markers in a chromosome based on an adapted version of the simpleM methodology}
\usage{
Nmarkers_SimpleM(ld.file, PCA_cutoff = 0.995)
}
\arguments{
\item{ld.file}{A data frame with the pairwise linkage disequilibrium (LD) values for a chromosome. The column names SNP_A, SNP_B, and R are mandatory, where the SNP_A and SNP_B contained the markers names and the R column the LD values between the two markers.}

\item{PCA_cutoff}{A cutoff for the total of the variance explained by the markers.}
}
\value{
The effective number of markers identified by the SimpleM approach
}
\description{
Estimate the number of effective markers in a chromosome based on an adapted version of the simpleM methodology
}
\details{
This function estimate the effective number of markers in a chromosome using adapted version of the simpleM methodology described in Gao et al. (2008). The function use as input a data frame composed by three mandatory columns (SNP_A, SNP_B, and R). This data frame can be obtained using PLINK or any other software to compute LD between markers. Additionally, a threshold for percentage of the sum of the variances explained by the markers must be provided. The number of effective markers identified by this approach can be used in multiple testing corrections, such as Bonferroni.
}
\references{
Gao et al. (2008) Genet Epidemiol, Volume 32, Issue 4, Pages 361-369.
(\doi{10.1002/gepi.20310})
}
